package it.unicam.pizzeria4.sala;

public class TavoloSala extends TavoloAttivo {

	private int capienza;
	private boolean isComposito;
	private Tavolo[] tavoliComponenti;

	public void setCapienza(int capienza) {
		this.capienza = capienza;
	}

	public void setComposito(boolean isComposito) {
		this.isComposito = isComposito;
	}

	public void setTavolo(Tavolo[] tavoliComponenti) {
		this.tavoliComponenti = tavoliComponenti;
	}

	public Tavolo[] getTavoliComponenti() {
		return tavoliComponenti;
	}

	public TavoloSala(Tavolo tavolo, String idComanda) {
		super();
		this.tavoliComponenti = new Tavolo[1];
		this.idComanda = idComanda;
		this.tavoliComponenti[0] = tavolo;
		this.capienza = tavolo.getCapienza();
		this.ID = tavolo.getID();
		this.isComposito = false;
		this.stato = TipoTavoloAttivo.standard;
	}

	public TavoloSala(Tavolo[] tavoliComponenti, String idComanda) {
		this.tavoliComponenti = new Tavolo[tavoliComponenti.length];
		this.capienza = 0;
		for (int i = 0; i < tavoliComponenti.length; i++) {
			this.capienza += tavoliComponenti[i].getCapienza();
			this.tavoliComponenti[i] = tavoliComponenti[i];
		}
		this.idComanda = idComanda;
		this.isComposito = true;
		this.stato = TipoTavoloAttivo.standard;
	}

	public boolean isComposito() {
		return isComposito;
	}

	public int getCapienza() {
		return capienza;
	}

}
